/*
 * Copyright (c) 2018 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_CALLSTATISTICS_H
#define SAILFISH_MDM_CALLSTATISTICS_H

#include <QObject>
#include <QDateTime>
#include <QList>
#include <QMetaType>

namespace Sailfish {
namespace Mdm {

class CallStatisticsPrivate;
class Q_DECL_EXPORT CallStatistics : public QObject
{
    Q_OBJECT

public:
    enum CallType {
        AnyCallType,
        OutgoingCall,
        MissedCall,
        IncomingCall
    };

    enum TimeInterval {
        NoTimeInterval,
        Yearly,
        Monthly,
        Weekly,
        Daily
    };

    struct Filter {
        CallType callType = AnyCallType;
        TimeInterval timeInterval = NoTimeInterval;
        QDateTime start;
        QDateTime end;
    };

    struct Result {
        QDateTime when;
        int callCount = 0;
    };

    CallStatistics(QObject *parent = 0);
    ~CallStatistics();

    void search(const Sailfish::Mdm::CallStatistics::Filter &filter);

Q_SIGNALS:
    void searchFinished(bool success, const QList<Sailfish::Mdm::CallStatistics::Result> &results);

private:
    CallStatisticsPrivate *d;
    Q_DISABLE_COPY(CallStatistics)
    Q_DECLARE_PRIVATE(CallStatistics)
};

}
}

Q_DECLARE_METATYPE(Sailfish::Mdm::CallStatistics::Result)
Q_DECLARE_METATYPE(QList<Sailfish::Mdm::CallStatistics::Result>)

#endif // SAILFISH_MDM_CALLSTATISTICS_H
