/*
 * Copyright (c) 2020 Open Mobile Platform LLС.
 *
 * License: Proprietary
 */

#ifndef MDM_CALLSHISTORY_H
#define MDM_CALLSHISTORY_H

#include <QObject>
#include <QDateTime>
#include <QList>
#include <QMetaType>

namespace Sailfish {
namespace Mdm {

class CallHistoryPrivate;
class Q_DECL_EXPORT CallHistory : public QObject
{
    Q_OBJECT

public:
    enum CallType {
        AnyCallType,
        OutgoingCall,
        MissedCall,
        IncomingCall
    };

    struct Filter {
        CallType callType = AnyCallType;
        QDateTime start;
        QDateTime end;
    };

    struct Result {
        QDateTime when;
        QDateTime finish;
        QString phoneNumber;
    };

    explicit CallHistory(QObject *parent = 0);
    ~CallHistory();

    void search(const Sailfish::Mdm::CallHistory::Filter &filter);

Q_SIGNALS:
    void searchFinished(bool success, const QList<Sailfish::Mdm::CallHistory::Result> &results);

private:
    CallHistoryPrivate *d;
    Q_DISABLE_COPY(CallHistory)
    Q_DECLARE_PRIVATE(CallHistory)
};

}
}

Q_DECLARE_METATYPE(Sailfish::Mdm::CallHistory::Result)
Q_DECLARE_METATYPE(QList<Sailfish::Mdm::CallHistory::Result>)

#endif
