/*
 * Copyright (c) 2017 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_BATTERYINFO_H
#define SAILFISH_MDM_BATTERYINFO_H

#include <QObject>

// nemo-qml-plugin-systemsettings
#include <batterystatus.h>

namespace Sailfish {
namespace Mdm {

class Q_DECL_EXPORT BatteryInfo : public BatteryStatus
{
    Q_OBJECT

public:
    BatteryInfo(QObject *parent = 0);

#ifdef Q_QDOC // to allow QDoc to find the signatures.
    enum ChargerStatus {
        Connected,
        Disconnected,
        ChargerStatusUnknown
    };

    enum Status {
        Full,
        Normal,
        Low,
        Empty
    };

    ChargerStatus chargerStatus() const;
    int chargePercentage() const;
    Status status() const;
signals:
    void chargerStatusChanged(ChargerStatus status);
    void chargePercentageChanged(int percentage);
    void statusChanged(Status status);
#endif
};

}
}

#endif // SAILFISH_MDM_BATTERYINFO_H
