/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023-2024 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0
import Aurora.Controls.private 1.0

Item {
    id: root

    property alias icon: image
    property alias highlighted: image.highlighted
    property bool closeOnClick: true

    signal clicked()
    signal _closePopup() // for close Popup when closeOnClick property is true

    width: Theme.dp(72)
    height: Theme.dp(72)
    opacity: enabled ? 1.0 : Theme.opacityLow

    Rectangle {
        anchors.fill: parent

        visible: highlighted
        color: Theme.rgba(palette.highlightColor, 0.2)
        radius: Theme.paddingSmall
    }

    Icon {
        id: image

        anchors.centerIn:  parent

        width: Theme.iconSizeSmallPlus
        height: Theme.iconSizeSmallPlus
        highlighted: mouseArea.containsMouse
    }

    MouseArea {
        id: mouseArea

        onClicked: {
            if (closeOnClick) {
                root._closePopup()
            }
            root.clicked()
        }

        anchors.fill: parent
    }
}
